#include <Servo.h>
Servo myservo;

uint32_t start_ms;
uint32_t start_us;

void setup() {
  start_us = micros();
  start_ms = millis();
  // put your setup code here, to run once:
  Serial.begin(115200);
  while(!Serial); // Wait for serial port to open from PC  
  delay(100);
  Serial.print("The board started at: ");  
  Serial.print(start_us);  
  Serial.print(" - ");  
  Serial.println(start_ms);  
  myservo.attach(5);
  myservo.write(90);
}

void loop() {
  static int value = 20;
  // put your main code here, to run repeatedly:
  if( micros() > start_us) {
    start_us =  micros() + 1000000;
    Serial.print(micros());  
    Serial.print(" - ");  
    Serial.println(millis());  
  }


  if( millis() > start_ms) {
    start_ms =  millis() + 2500;
    myservo.write(value);
    value += 20;
    if(value > 145) value = 20;
  }

}
