/*
  Blink Task
  Blink LED1 with a 500ms cycle (2Hz)
  Blink LED2 with a 510ms cycle (1.96Hz)
  Utlizing the chipKIT task manager rather than delay functions.
  This example code is in the public domain.
*/
#include <Servo.h>
Servo myservo;

uint32_t start_ms;
uint32_t start_us;

int blink1_id;
int blink2_id;
unsigned long blink1_var;
unsigned long blink2_var;

void blink_task1(int id, void * tptr) {
  Serial.print(micros());
  Serial.print(" - ");
  Serial.println(millis());
}
void blink_task2(int id, void * tptr) {
  static int value = 20;
  myservo.write(value);
  value += 20;
  if (value > 145) value = 20;
}
void setup() {
  start_us = micros();
  start_ms = millis();
  
  Serial.begin(115200);
  while (!Serial); // Wait for serial port to open from PC
  delay(100);
  Serial.print("The board started at: ");
  Serial.print(start_us);
  Serial.print(" - ");
  Serial.println(start_ms);
  myservo.attach(5);
  myservo.write(90);

  // initialize the digital pin as an output.
  // Pin 13 has an LED connected on most Arduino boards:
//  pinMode(PIN_LED1, OUTPUT);
//  pinMode(PIN_LED2, OUTPUT);
  blink1_id = createTask(blink_task1, 1000, TASK_ENABLE, &blink1_var);
  blink2_id = createTask(blink_task2, 2500, TASK_ENABLE, &blink2_var);
}
void loop() {
}
