char command[0x20];
/////////////////////////////////////////////////////////
// The data structure below hold the win/tie/loose
// information for the complete rock, paper sissors
/////////////////////////////////////////////////////////
//   P1\P2 | rock pape siss lizz spoc
//   -------------------------------
//    rock | draw  P2   P1   P1   P2
//   paper |  P1  draw  P2   P2   P1
// sissors |  P2   P1  draw  P1   P2
// lizzard |  P2   P1   P2  draw  P1
//   spock |  P1   P2   P1   P2  draw
//
/////////////////////////////////////////////////////////
// Key
/////////////////////////////////////////////////////////
// 0 = draw / tie
// 1 = player 1 win
// 2 = player 2 win
/////////////////////////////////////////////////////////
uint8_t p1p2[5][5] = {
  { 0, 2, 1, 1, 2 },
  { 1, 0, 2, 2, 1 },
  { 2, 1, 0, 1, 2 },
  { 2, 1, 2, 0, 1 },
  { 1, 2, 1, 2, 0 }
};

void setup()
{
  Serial.begin(115200);
  pinMode(PIN_LED1, OUTPUT);
}

void loop()
{
  uint8_t user, computer;
  if (receive_function(command, sizeof(command)))
  {
    // clear "user" selection
    // 0xff is used because it is outside the range of possible choices
    user = 0xff;
    if (strcmp(command, "toggle") == 0)
    {
      digitalWrite(LED_BUILTIN, !digitalRead(LED_BUILTIN)); // if they match turn the led on
      Serial.println("LED toggled");
    }
    else if (strcmp(command, "grid") == 0)
    {
      // Displays the win draw loose datastructure in a grid
      uint8_t p1, p2;
      for (p1 = 0; p1 < 5; p1++) {
        for (p2 = 0; p2 < 5; p2++) {
          Serial.print(p1p2[p1][p2], DEC);
          Serial.print(" ");
        }
        Serial.println("");
      }
    }
    else if (strcmp(command, "rock") == 0){
      user = 0;
    }
    else // parser command not found
    {
      Serial.println("Choose: rock, paper, sissors, lizard, spock.");
    }
  }
}

